/*
 * Decompiled with CFR 0.152.
 */
package flash.io;

import exploit.control.AppControl;
import flash.io.BitInput;
import flash.io.BitLibrary;
import flash.io.FlashFilter;
import flash.io.TagReaderImage;
import flash.io.TypeReader;
import flash.objects.FBitmap;
import flash.objects.FColor;
import flash.objects.FEdge;
import flash.objects.FFill;
import flash.objects.FFont;
import flash.objects.FImage;
import flash.objects.FLine;
import flash.objects.FLossless;
import flash.objects.FMorph;
import flash.objects.FMovie;
import flash.objects.FMovieInterface;
import flash.objects.FRect;
import flash.objects.FShape;
import flash.objects.FSound;
import flash.objects.FSprite;
import flash.objects.FStyle;
import flash.objects.FStyleChange;
import flash.objects.FText;
import flash.objects.FTextGlyph;
import flash.objects.FTextRecord;
import flash.objects.FTexture;
import flash.tags.PlaceObject;
import flash.tags.RemoveObject;
import flash.tags.Tag;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class TagReader {
    private BitInput bi;
    private BitLibrary bl;
    private int version;
    private TypeReader myTypeReader;
    private FlashFilter myFilter;
    private FMovie coreMovie;
    private TagReaderImage myImageReader;
    private boolean isDebug;
    private int myMaxFrame = -1;

    public TagReader(TypeReader typeReader, BitLibrary bitLibrary, BitInput bitInput, int n, FlashFilter flashFilter) {
        this.bl = bitLibrary;
        this.bi = bitInput;
        this.myTypeReader = typeReader;
        this.version = n;
        this.isDebug = AppControl.getInfo().getDebug();
        this.myFilter = flashFilter;
        this.myImageReader = this.myFilter.getFilter(3) ? new TagReaderImage(this.isDebug, bitInput, bitLibrary, this.myTypeReader, this.myFilter) : null;
        if (this.isDebug) {
            System.out.println("Tag Reader: Active");
        }
    }

    public void setMaxFrame(int n) {
        this.myMaxFrame = n;
    }

    public void setFilter(FlashFilter flashFilter) {
        this.myFilter = flashFilter;
    }

    public String parseTags(FMovieInterface fMovieInterface, long l, int n) throws IOException {
        Tag tag = null;
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        if (n == 0) {
            this.coreMovie = (FMovie)fMovieInterface;
        }
        while (this.bi.bitsRead < l && n2 != this.myMaxFrame) {
            tag = this.myTypeReader.tag();
            if (this.isDebug) {
                System.out.println("Byte:" + this.bi.bitsRead + " " + tag);
            }
            l2 = this.bi.bitsRead;
            l3 = l2 + tag.length;
            switch (tag.id) {
                case 0: 
                case 1: {
                    fMovieInterface.addTag(tag);
                    if (n != 0) break;
                    ++n2;
                    break;
                }
                case 2: {
                    if (n != 0) break;
                    if (!this.myFilter.getFilter(0)) break;
                    FShape fShape = this.parseDefineShape(1);
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(fShape.getID(), fShape);
                    break;
                }
                case 4: {
                    PlaceObject placeObject = this.parsePlaceObject(l3);
                    tag.myObject = placeObject;
                    fMovieInterface.addTag(tag);
                    break;
                }
                case 5: {
                    tag.myObject = this.parseRemoveObject(1);
                    fMovieInterface.addTag(tag);
                    break;
                }
                case 6: {
                    if (!this.myFilter.getFilter(3)) break;
                    FBitmap fBitmap = this.myImageReader.parseBitmap(1, tag.length);
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(fBitmap.getID(), fBitmap);
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    if (!this.myFilter.getFilter(3)) break;
                    this.myImageReader.parseBitmap(0, tag.length);
                    break;
                }
                case 9: {
                    tag.myObject = this.myTypeReader.rgba(1);
                    this.coreMovie.setBackgroundColor(((FColor)tag.myObject).toColor());
                    fMovieInterface.addTag(tag);
                    break;
                }
                case 10: {
                    FFont fFont = this.parseDefineFont();
                    if (fFont == null) break;
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(fFont.getID(), fFont);
                    break;
                }
                case 11: {
                    FText fText = this.parseText(1);
                    if (fText == null) break;
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(fText.getID(), fText);
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    if (!this.myFilter.getFilter(1)) break;
                    FSound fSound = this.DefineSound(tag.length);
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(fSound.getID(), fSound);
                    break;
                }
                case 17: {
                    break;
                }
                case 18: 
                case 45: {
                    break;
                }
                case 19: {
                    break;
                }
                case 20: {
                    if (!this.myFilter.getFilter(3)) break;
                    FLossless fLossless = this.myImageReader.parseLossless(1, (int)tag.length);
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(fLossless.getID(), fLossless);
                    break;
                }
                case 21: {
                    if (!this.myFilter.getFilter(3)) break;
                    FBitmap fBitmap = this.myImageReader.parseBitmap(2, tag.length);
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(fBitmap.getID(), fBitmap);
                    break;
                }
                case 22: {
                    if (n != 0) break;
                    if (!this.myFilter.getFilter(0)) break;
                    FShape fShape = this.parseDefineShape(2);
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(fShape.getID(), fShape);
                    break;
                }
                case 23: {
                    break;
                }
                case 24: {
                    break;
                }
                case 26: 
                case 70: {
                    PlaceObject placeObject = this.parsePlaceObject2(tag.id == 26 ? 2 : 3);
                    tag.myObject = placeObject;
                    fMovieInterface.addTag(tag);
                    break;
                }
                case 28: {
                    tag.myObject = this.parseRemoveObject(2);
                    fMovieInterface.addTag(tag);
                    break;
                }
                case 32: {
                    if (n != 0) break;
                    if (!this.myFilter.getFilter(0)) break;
                    FShape fShape = this.parseDefineShape(3);
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(fShape.getID(), fShape);
                    break;
                }
                case 33: {
                    FText fText = this.parseText(2);
                    if (fText == null) break;
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(fText.getID(), fText);
                    break;
                }
                case 34: {
                    break;
                }
                case 35: {
                    if (!this.myFilter.getFilter(3)) break;
                    Object object = this.myImageReader.parseBitmap(3, tag.length);
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(((FBitmap)object).getID(), object);
                    break;
                }
                case 36: {
                    Object object;
                    if (!this.myFilter.getFilter(3) || (object = this.myImageReader.parseLossless(2, (int)tag.length)) == null) break;
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(((FLossless)object).getID(), object);
                    break;
                }
                case 37: {
                    break;
                }
                case 38: {
                    break;
                }
                case 39: {
                    if (!this.myFilter.getFilter(0)) break;
                    Object object = this.parseDefineSprite(n, l, fMovieInterface.getCore());
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(((FSprite)object).getID(), object);
                    break;
                }
                case 43: {
                    break;
                }
                case 46: {
                    if (n != 0) break;
                    if (!this.myFilter.getFilter(0)) break;
                    Object object = this.parseMorphShape();
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(((FMorph)object).getID(), object);
                    break;
                }
                case 48: {
                    Object object;
                    if (!this.myFilter.getFilter(2) || (object = this.parseDefineFont2(2)) == null) break;
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(((FFont)object).getID(), object);
                    break;
                }
                case 56: {
                    break;
                }
                case 57: {
                    break;
                }
                case 58: {
                    break;
                }
                case 75: {
                    Object object;
                    if (!this.myFilter.getFilter(2) || (object = this.parseDefineFont2(3)) == null) break;
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(((FFont)object).getID(), object);
                    break;
                }
                case 83: {
                    if (n != 0) break;
                    if (!this.myFilter.getFilter(0)) break;
                    Object object = this.parseDefineShape(4);
                    this.coreMovie = (FMovie)fMovieInterface;
                    this.coreMovie.add(((FShape)object).getID(), object);
                    break;
                }
                case 1023: {
                    break;
                }
            }
            if (tag.id == 0 || tag.length < 0L) break;
            if (this.bi.bitsRead < l3) {
                long l4 = l3 - this.bi.bitsRead;
                this.bi.skip(l4);
                continue;
            }
            if (this.bi.bitsRead <= l3) continue;
            System.out.println("Error:Overbyte:" + (this.bi.bitsRead - l3) + " " + this.bi.bitsRead + "\\" + l3);
            return "Error: OVERBYTE when reading " + tag + " " + (this.bi.bitsRead - l3) + " " + this.bi.bitsRead + "\\" + l3;
        }
        return null;
    }

    private FSound DefineSoundHead() throws IOException {
        this.bl.ub(4);
        this.bl.ub(2);
        this.bl.ub(1);
        this.bl.ub(1);
        int n = (int)this.bl.ub(4);
        FSound fSound = new FSound(-50, n, 0, false, false, 0L, null);
        return fSound;
    }

    private FSound DefineSound(long l) throws IOException {
        int n = (int)this.bl.ui16();
        int n2 = (int)this.bl.ub(4);
        int n3 = (int)this.bl.ub(2);
        boolean bl = this.bl.ub(1) != 0L;
        boolean bl2 = this.bl.ub(1) != 0L;
        long l2 = this.bl.ui32();
        int[] nArray = this.bi.readBytes((int)l - 7);
        FSound fSound = new FSound(n, n2, n3, bl, bl2, l2, nArray);
        return fSound;
    }

    private RemoveObject parseRemoveObject(int n) throws IOException {
        RemoveObject removeObject = null;
        if (n == 1) {
            removeObject = new RemoveObject((int)this.bl.ui16(), (int)this.bl.ui16());
        } else if (n == 2) {
            removeObject = new RemoveObject((int)this.bl.ui16());
        }
        return removeObject;
    }

    private PlaceObject parsePlaceObject(long l) throws IOException {
        PlaceObject placeObject = new PlaceObject();
        placeObject.setPlaceFlagHasMatrix();
        placeObject.setPlaceFlagHasCharacter();
        placeObject.setID((int)this.bl.ui16());
        placeObject.setDepth((int)this.bl.ui16());
        placeObject.setMatrix(this.myTypeReader.matrix());
        return placeObject;
    }

    private PlaceObject parsePlaceObject2(int n) throws IOException {
        PlaceObject placeObject = new PlaceObject();
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n == 3) {
            n2 = (int)this.bl.ub(5);
            bl = this.bl.ub(1) == 1L;
            bl2 = this.bl.ub(1) == 1L;
            bl3 = this.bl.ub(1) == 1L;
        }
        int n3 = (int)this.bl.ui8();
        placeObject.setDepth((int)this.bl.ui16());
        if ((n3 & 0x40) == 64) {
            placeObject.setPlaceFlagHasClipActions();
        }
        if ((n3 & 0x80) == 128) {
            placeObject.setPlaceFlagReserved();
        }
        if ((n3 & 0x20) == 32) {
            placeObject.setPlaceFlagHasName();
        }
        if ((n3 & 0x10) == 16) {
            placeObject.setPlaceFlagHasRatio();
        }
        if ((n3 & 8) == 8) {
            placeObject.setPlaceFlagHasColorTransform();
        }
        if ((n3 & 4) == 4) {
            placeObject.setPlaceFlagHasMatrix();
        }
        if ((n3 & 2) == 2) {
            placeObject.setPlaceFlagHasCharacter();
        }
        if ((n3 & 1) == 1) {
            placeObject.setPlaceFlagMove();
        }
        if (placeObject.getPlaceFlagHasCharacter()) {
            placeObject.setID((int)this.bl.ui16());
        }
        if (placeObject.getPlaceFlagHasMatrix()) {
            placeObject.setMatrix(this.myTypeReader.matrix());
        }
        if (placeObject.getPlaceFlagHasColorTransform()) {
            placeObject.setCXFORM(this.myTypeReader.cxform(true));
        }
        if (placeObject.getPlaceFlagHasRatio()) {
            placeObject.setRatio((int)this.bl.ui16());
        }
        if (placeObject.getPlaceFlagHasName()) {
            placeObject.setName(this.myTypeReader.string());
        }
        if (placeObject.getPlaceFlagHasClipActions()) {
            placeObject.setClipDepth((int)this.bl.ui16());
        }
        return placeObject;
    }

    private FSprite parseDefineSprite(int n, long l, FMovie fMovie) throws IOException {
        FSprite fSprite = new FSprite((int)this.bl.ui16(), this.bl.ui16(), fMovie);
        this.parseTags(fSprite, l, n + 1);
        return fSprite;
    }

    private FShape parseDefineShape(int n) throws IOException {
        int n2 = (int)this.bl.ui16();
        FRect fRect = this.myTypeReader.rect();
        this.bi.align();
        FShape fShape = new FShape(n, n2, fRect);
        FStyle fStyle = fShape.getStyle();
        if (n == 4) {
            FRect fRect2 = this.myTypeReader.rect();
            this.bi.align();
            fShape.setStrokeRect(fRect2);
            int n3 = (int)this.bl.ub(6);
            boolean bl = this.bl.ub(1) == 1L;
            boolean bl2 = this.bl.ub(1) == 1L;
            fShape.setShapeNonScales(bl);
            fShape.setShapeScales(bl2);
        }
        this.parseFillStyleArray(fStyle.getFillStyles(), n);
        this.parseLineStyleArray(fStyle.getLineStyles(), n);
        this.parseShapeRecord(fStyle.getShapeRecords(), n);
        return fShape;
    }

    private void parseFillStyleArray(Vector vector, int n) throws IOException {
        int n2 = (int)this.bl.ui8();
        if (n > 1 && n2 == 255) {
            n2 = (int)this.bl.ui16();
        }
        for (int i = 0; i < n2; ++i) {
            FFill fFill = this.myTypeReader.fillstyle(n);
            if (this.myFilter.getFilter(3) && fFill instanceof FTexture) {
                FTexture fTexture = (FTexture)fFill;
                fTexture.setBitmap((FImage)this.coreMovie.getObjects().get("" + fTexture.getBitmapID()));
            }
            vector.add(fFill);
        }
    }

    private void parseLineStyleArray(Vector vector, int n) throws IOException {
        int n2 = (int)this.bl.ui8();
        if (n2 == 255) {
            n2 = (int)this.bl.ui16();
        }
        for (int i = 0; i < n2; ++i) {
            FLine fLine = this.myTypeReader.linestyle(n);
            vector.add(fLine);
        }
    }

    private void parseTextRecord(int n, int n2, int n3, Vector vector) throws IOException {
        int n4 = 0;
        block4: while (true) {
            this.bi.align();
            n4 = (int)this.bl.ub(1);
            switch (n4) {
                case 0: {
                    int n5 = (int)this.bl.ub(7);
                    if (n5 == 0) {
                        return;
                    }
                    int n6 = 0;
                    while (true) {
                        if (n6 >= n5) continue block4;
                        vector.add(new FTextGlyph((int)this.bl.ub(n2), (int)this.bl.sb(n3)));
                        ++n6;
                    }
                }
                case 1: {
                    int n7;
                    FTextRecord fTextRecord = new FTextRecord(n);
                    int n6 = (int)this.bl.ub(3);
                    int n8 = (int)this.bl.ub(1);
                    int n9 = (int)this.bl.ub(1);
                    int n10 = (int)this.bl.ub(1);
                    int n11 = (int)this.bl.ub(1);
                    vector.add(fTextRecord);
                    if (n8 == 1) {
                        n7 = (int)this.bl.ui16();
                        fTextRecord.setFont((FFont)this.coreMovie.findObject(n7));
                    }
                    if (n9 == 1) {
                        FColor fColor = this.myTypeReader.rgba(n == 1 ? 1 : 3);
                        fTextRecord.setColor(fColor);
                    }
                    if (n11 == 1) {
                        n7 = (int)this.bl.si16();
                        fTextRecord.setOffsetX(n7);
                    }
                    if (n10 == 1) {
                        n7 = (int)this.bl.si16();
                        fTextRecord.setOffsetY(n7);
                    }
                    if (n8 != 1) break;
                    n7 = (int)this.bl.ui16();
                    fTextRecord.setHeight(n7);
                }
            }
        }
    }

    private void parseShapeRecord(Vector vector, int n) throws IOException {
        block15: {
            int n2;
            int n3 = (int)this.bl.ub(4);
            int n4 = (int)this.bl.ub(4);
            while (true) {
                int n5;
                if ((n2 = (int)this.bl.ub(1)) == 0) {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    n5 = 0;
                    int n10 = (int)this.bl.ub(1);
                    n5 = n10 + (n9 = (int)this.bl.ub(1)) + (n8 = (int)this.bl.ub(1)) + (n7 = (int)this.bl.ub(1)) + (n6 = (int)this.bl.ub(1));
                    if (n5 != 0) {
                        FStyleChange fStyleChange = new FStyleChange();
                        if (n6 == 1) {
                            int n11 = (int)this.bl.ub(5);
                            fStyleChange.setMoveDeltaX(this.bl.sb(n11));
                            fStyleChange.setMoveDeltaY(this.bl.sb(n11));
                        }
                        if (n7 == 1) {
                            fStyleChange.setFillStyle0((int)this.bl.ub(n3));
                        }
                        if (n8 == 1) {
                            fStyleChange.setFillStyle1((int)this.bl.ub(n3));
                        }
                        if (n9 == 1) {
                            fStyleChange.setLineStyle((int)this.bl.ub(n4));
                        }
                        if (n10 == 1 && n > 1) {
                            this.parseFillStyleArray(fStyleChange.getFillStyleArray(), n);
                            this.parseLineStyleArray(fStyleChange.getLineStyleArray(), n);
                            n3 = (int)this.bl.ub(4);
                            n4 = (int)this.bl.ub(4);
                        }
                        vector.add(fStyleChange);
                        continue;
                    }
                    break block15;
                }
                if (n2 != 1) break;
                n2 = (int)this.bl.ub(1);
                n5 = (int)this.bl.ub(4) + 2;
                FEdge fEdge = null;
                if (n2 == 0) {
                    fEdge = new FEdge(0);
                    fEdge.setControlDeltaX(this.bl.sb(n5));
                    fEdge.setControlDeltaY(this.bl.sb(n5));
                    fEdge.setAnchorDeltaX(this.bl.sb(n5));
                    fEdge.setAnchorDeltaY(this.bl.sb(n5));
                } else if (n2 == 1) {
                    fEdge = new FEdge(1);
                    if (this.bl.ub(1) == 1L) {
                        fEdge.setDeltaX(this.bl.sb(n5));
                        fEdge.setDeltaY(this.bl.sb(n5));
                    } else if (this.bl.ub(1) == 1L) {
                        fEdge.setDeltaY(this.bl.sb(n5));
                    } else {
                        fEdge.setDeltaX(this.bl.sb(n5));
                    }
                }
                vector.add(fEdge);
            }
            IOException iOException = new IOException("Read Error:-" + n2);
            throw iOException;
        }
    }

    private FMorph parseMorphShape() throws IOException {
        int n = (int)this.bl.ui16();
        FRect fRect = this.myTypeReader.rect();
        this.bi.align();
        FRect fRect2 = this.myTypeReader.rect();
        FMorph fMorph = new FMorph(n, fRect, fRect2);
        long l = this.bl.ui32();
        this.parseMorphFillStyleArray(fMorph.getStartStyle().getFillStyles());
        this.parseMorphLineStyleArray(fMorph.getStartStyle().getLineStyles());
        this.parseMorphRecord(fMorph.getStartStyle().getShapeRecords(), -1L);
        this.bi.align();
        this.parseMorphRecord(fMorph.getEndStyle().getShapeRecords(), -1L);
        return fMorph;
    }

    private void parseMorphFillStyleArray(Vector vector) throws IOException {
        int n = (int)this.bl.ui8();
        if (n == 255) {
            n = (int)this.bl.ui16();
        }
        for (int i = 0; i < n; ++i) {
            vector.add(this.myTypeReader.morphFillStyle());
        }
    }

    private void parseMorphLineStyleArray(Vector vector) throws IOException {
        int n = (int)this.bl.ui8();
        if (n == 255) {
            n = (int)this.bl.ui16();
        }
        for (int i = 0; i < n; ++i) {
            vector.add(this.myTypeReader.morphLineStyle());
        }
    }

    private void parseMorphRecord(Vector vector, long l) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = (int)this.bl.ub(4);
        n2 = (int)this.bl.ub(4);
        while (true) {
            int n4;
            int n5;
            if ((n5 = (int)this.bl.ub(1)) == 0) {
                int n6;
                int n7;
                int n8;
                int n9;
                n4 = 0;
                int n10 = (int)this.bl.ub(1);
                n4 = n10 + (n9 = (int)this.bl.ub(1)) + (n8 = (int)this.bl.ub(1)) + (n7 = (int)this.bl.ub(1)) + (n6 = (int)this.bl.ub(1));
                if (n4 == 0) break;
                FStyleChange fStyleChange = new FStyleChange();
                if (n6 == 1) {
                    int n11 = (int)this.bl.ub(5);
                    fStyleChange.setMoveDeltaX(this.bl.sb(n11));
                    fStyleChange.setMoveDeltaY(this.bl.sb(n11));
                }
                if (n7 == 1) {
                    fStyleChange.setFillStyle0((int)this.bl.ub(n));
                }
                if (n8 == 1) {
                    fStyleChange.setFillStyle1((int)this.bl.ub(n));
                }
                if (n9 == 1) {
                    fStyleChange.setLineStyle((int)this.bl.ub(n2));
                }
                if (n10 == 1) {
                    this.parseMorphFillStyleArray(fStyleChange.getFillStyleArray());
                    this.parseMorphLineStyleArray(fStyleChange.getLineStyleArray());
                    n = (int)this.bl.ub(4);
                    n2 = (int)this.bl.ub(4);
                }
                vector.add(fStyleChange);
                continue;
            }
            if (n5 != 1) continue;
            n5 = (int)this.bl.ub(1);
            n4 = (int)this.bl.ub(4) + 2;
            FEdge fEdge = null;
            if (n5 == 0) {
                fEdge = new FEdge(0, n3++);
                fEdge.setControlDeltaX(this.bl.sb(n4));
                fEdge.setControlDeltaY(this.bl.sb(n4));
                fEdge.setAnchorDeltaX(this.bl.sb(n4));
                fEdge.setAnchorDeltaY(this.bl.sb(n4));
            } else if (n5 == 1) {
                fEdge = new FEdge(1, n3++);
                if (this.bl.ub(1) == 1L) {
                    fEdge.setDeltaX(this.bl.sb(n4));
                    fEdge.setDeltaY(this.bl.sb(n4));
                } else if (this.bl.ub(1) == 1L) {
                    fEdge.setDeltaY(this.bl.sb(n4));
                } else {
                    fEdge.setDeltaX(this.bl.sb(n4));
                }
            }
            vector.add(fEdge);
        }
    }

    public FFont parseDefineFont() throws IOException {
        FFont fFont = new FFont(1, (int)this.bl.ui16());
        long l = this.bi.bitsRead;
        int n = (int)this.bl.ui16();
        int n2 = n / 2;
        long[] lArray = new long[n2];
        lArray[0] = n;
        for (int i = 1; i < n2; ++i) {
            lArray[i] = (int)this.bl.ui16();
        }
        Vector[] vectorArray = new Vector[n2];
        for (int i = 0; i < n2; ++i) {
            Serializable serializable;
            this.bi.align();
            if (this.bi.bitsRead - l != lArray[i]) {
                if (this.isDebug) {
                    System.out.println("Overbyte in Glyphs");
                }
                serializable = new IOException("Glyph Error:- Overbyte " + (this.bi.bitsRead - l - lArray[i]));
                throw serializable;
            }
            serializable = new Vector();
            this.parseShapeRecord((Vector)serializable, 3);
            vectorArray[i] = serializable;
        }
        fFont.setGlyphs(vectorArray);
        return fFont;
    }

    public FFont parseDefineFont2(int n) throws IOException {
        int n2;
        int n3;
        FFont fFont = new FFont(n, (int)this.bl.ui16());
        for (n3 = 0; n3 < 8; ++n3) {
            fFont.setFlag(n3, (int)this.bl.ub(1) == 1);
        }
        this.bi.skip(1L);
        n3 = (int)this.bl.ui8();
        fFont.setName(this.myTypeReader.string(n3));
        int n4 = (int)this.bl.ui16();
        fFont.setGlyphCount(n4);
        long l = this.bi.bitsRead;
        long[] lArray = new long[n4];
        long l2 = 0L;
        if (fFont.getFlag(4)) {
            for (n2 = 0; n2 < n4; ++n2) {
                lArray[n2] = this.bl.ui32();
            }
            l2 = this.bl.ui32();
        } else {
            for (n2 = 0; n2 < n4; ++n2) {
                lArray[n2] = this.bl.ui16();
            }
            l2 = this.bl.ui16();
        }
        fFont.setGlyphOffsetTable(lArray);
        Vector[] vectorArray = new Vector[n4];
        for (int i = 0; i < n4; ++i) {
            Serializable serializable;
            this.bi.align();
            if (this.bi.bitsRead - l != lArray[i]) {
                if (this.isDebug) {
                    System.out.println("Overbyte in Glyphs");
                }
                serializable = new IOException("Glyph Error:- Overbyte " + (this.bi.bitsRead - l - lArray[i]));
                throw serializable;
            }
            serializable = new Vector();
            this.parseShapeRecord((Vector)serializable, 3);
            vectorArray[i] = serializable;
        }
        fFont.setGlyphs(vectorArray);
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = fFont.getFlag(5) ? (int)this.bl.ui16() : (int)this.bl.ui8();
        }
        fFont.setCodeOffsets(nArray);
        nArray = null;
        if (fFont.getFlag(0)) {
            fFont.setFontAscent((int)this.bl.si16());
            fFont.setFontDescent((int)this.bl.si16());
            fFont.setFontLeading((int)this.bl.si16());
            int[] nArray2 = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray2[i] = (int)this.bl.si16();
            }
            fFont.setFontAdvanceTable(nArray2);
            FRect[] fRectArray = new FRect[n4];
            for (int i = 0; i < n4; ++i) {
                fRectArray[i] = this.myTypeReader.rect();
                this.bi.align();
            }
            fFont.setFontBoundsTable(fRectArray);
            fFont.setFontKerningCount((int)this.bl.si16());
        }
        return fFont;
    }

    private FText parseText(int n) throws IOException {
        FText fText = new FText(n, (int)this.bl.ui16());
        fText.setRect(this.myTypeReader.rect());
        fText.setMatrix(this.myTypeReader.matrix());
        int n2 = (int)this.bl.ui8();
        int n3 = (int)this.bl.ui8();
        Vector vector = new Vector();
        this.parseTextRecord(n, n2, n3, vector);
        fText.setRecords(vector);
        return fText;
    }
}

